
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:54:43 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_HASH_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_HASH_Acceptance.h"
#include "CRYS_ATP_TST_HASH_Acceptance_test_vectors.h"

#include "DX_VOS_Mem.h"
#include <stdio.h>
#include <math.h>
#if TST_USE_HASH_DATA/*In case no test vectors are selected - code disabled*/
/******** Defines **********/
/******** Enums **********/
/******** Typedefs **********/
/******** Global Data **********/
/***** Private function prototype ******/
/******** Public Functions **********/
/******** Private Functions **********/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_HASH_Acceptance_NON_integrated         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for HASH non integrated API's                            
 *  This function HASH known vectors using SHA1\SHA224\SHA256\SHA384\SHA512 and MD5
 *  Vector sizes used (in bytes) - 16/32/512/1536                                 
 * Algorithm:       
 * 1. Call the CRYS_HASH_Init function to start the encryption/decryption process
 * 2. Call the CRYS_HASH_Update - This function is called N times
 *                                (N = number of blocks in data each block is 16byte)
 * 3. Call the CRYS_HASH_Finish to end the HASH process and get the Digest result
 * 4. Compare the outputted result to the expected one                                                   
 *
 **************************/                                
CRYSError_t CRYS_ATP_TST_HASH_Acceptance_NON_integrated ( void )
{

    /*** TST Variables Definitions ****/
    int                     TST_index, Block_index ,NumOfBlocks;
    CRYSError_t             TST_Status=0;
    int                     TST_HashType;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_HASH_Acceptance_NON_integrated";
    CRYS_HASHUserContext_t  TST_ContextID_ptr;

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ATP_TST_HASH_Acceptance_NON_integrated Tests ******** \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_HashType = 0;  TST_HashType <CRYS_HASH_NumOfModes ; TST_HashType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOfHASHAcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            switch(TST_HashType)
            {
            case CRYS_HASH_SHA1_mode:
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA1_mode;
                break;
            case CRYS_HASH_SHA224_mode:
                TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA224_mode;
                break;
            case CRYS_HASH_SHA256_mode:
                TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA256_mode;
                break;
            case CRYS_HASH_SHA384_mode:
                #ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
                TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA384_mode;
                break;
                #else
                continue;
                #endif
            case CRYS_HASH_SHA512_mode:
                #ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
                TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA512_mode;
                break;
                #else
                continue;
                #endif
            case CRYS_HASH_MD5_mode:                                       
                TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_MD5_mode;
                break;
            default:
                break;
            }
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_index));
            CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
            
            TST_Status = TESTPASS;
                    
            /* calling the HASH init function */
            /*--------------------------------*/
            TST_Status = CRYS_HASH_Init(&TST_ContextID_ptr,
                                        TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode);
                             
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH_Init",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
 
            
            /* calling the HASH Update function */
            /*----------------------------------*/    
            NumOfBlocks = TST_HASH_Acceptance_TestData[TST_index].TST_input_dataSize/TST_MAX_SINGLE_HASH_BLOCK_SIZE_IN_BYTS;
                
            
            /* Debug massages */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"number of blocks = %1d \n",NumOfBlocks));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_HASH_Acceptance_TestData[TST_index].TST_input_dataSize));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"SingleBlockSize [byte] = %1d \n",TST_MAX_SINGLE_HASH_BLOCK_SIZE_IN_BYTS));
            
            for (Block_index = 0 ; Block_index < NumOfBlocks ; Block_index++)/*HASH block loop*/
            {   
                             
                TST_Status = CRYS_HASH_Update(&TST_ContextID_ptr,
                                              TST_HASH_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_HASH_BLOCK_SIZE_IN_BYTS*Block_index),
                                              TST_MAX_SINGLE_HASH_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t));                       
                          
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH_Update",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
 
                                          
            }/*End HASH block loop*/

                            
            /* calling the Finish function */
            /*-----------------------------*/       
            TST_Status = CRYS_HASH_Finish(&TST_ContextID_ptr,
                                          TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff);
            
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH_Finish",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
                
                        
            /* Compare the result to expected result and then Print the expected Vs Outputted*/
            /*------------------------------------------------------------------------------*/
            switch(TST_HashType)
            {
            case CRYS_HASH_SHA1_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data,
                                           CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA224_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA224_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA224_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA224_Expected_output_data,
                                           CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA256_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA256_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA256_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA256_Expected_output_data,
                                           CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA384_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA384_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA384_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA384_Expected_output_data,
                                           CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA512_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA512_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA512_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA512_Expected_output_data,
                                           CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_MD5_mode:                                       
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_MD5_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_MD5_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_MD5_Expected_output_data,
                                           CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES);
                break;
            default:
                break;
            }
                
            ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                        "\nData outputted by engine [output buffer]--\n",
                                        (DxUint8_t *)TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff,
                                        CRYS_HASH_RESULT_SIZE_IN_WORDS*sizeof(DxUint32_t));                   

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
  
            
        }/*End of TST_index//TST_NumberOfAcceptanceTests*/      
    } /* End of TST_HashType loop*/
  return TST_Status;
   
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
} /*End of test*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_HASH_Acceptance_Integrated         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for HASH integrated API                          
 *  This function HASH known vectors using SHA1\SHA224\SHA256\SHA384\SHA512 and MD5
 *  Vector sizes used (in bytes) - 16/32/512                                                         
 * Algorithm:       
 * 1. Call the CRYS_HASH function to use the HASH process
 * 2. Compare the outputted result to the expected one                                                   
 *
 **************************/
CRYSError_t CRYS_ATP_TST_HASH_Acceptance_Integrated ( void )
{

    /*** TST Variables Definitions ****/
    int         TST_index;
    CRYSError_t TST_Status=0;
    int         TST_HashType;
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_HASH_Acceptance_Integrated";        
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ATP_TST_HASH_Acceptance_Integrated Tests ******** \n"));        
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_HashType = 0;  TST_HashType <CRYS_HASH_NumOfModes ; TST_HashType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOfHASHAcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            switch(TST_HashType)
            {
                case CRYS_HASH_SHA1_mode:
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA1_mode;
                break;
                case CRYS_HASH_SHA224_mode:
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA224_mode;
                    break;
                case CRYS_HASH_SHA256_mode:
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA256_mode;
                    break;
                case CRYS_HASH_SHA384_mode:
                    #ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA384_mode;
                    break;
                    #else
                    continue;
                    #endif
                case CRYS_HASH_SHA512_mode:
                    #ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA512_mode;
                    break;
                    #else
                    continue;
                    #endif
                case CRYS_HASH_MD5_mode:
                    TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_MD5_mode;
                    break;
                default:
                    break;
            }
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_index));
            CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
            
            TST_Status = TESTPASS;
            
            /* Debug massages */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_HASH_Acceptance_TestData[TST_index].TST_input_dataSize));
                    
            /* calling the HASH function */
            /*---------------------------*/
            TST_ATP_StartPerformanceTimer(&TST_Timer);

            TST_Status = CRYS_HASH(TST_HASH_Acceptance_TestData[TST_index].TST_OperationMode,
                                      TST_HASH_Acceptance_TestData[TST_index].TST_input_data,
                                      TST_HASH_Acceptance_TestData[TST_index].TST_input_dataSize,
                                      TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff);

            TST_ATP_GetPerformanceTimer(&TST_Timer);
            TST_ATP_CalcPerformance(TST_HASH_Acceptance_TestData[TST_index].TST_input_dataSize);

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_HASH",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);

                        
            /* Compare the result to expected result and then Print the expected Vs Outputted*/
            /*------------------------------------------------------------------------------*/
            switch(TST_HashType)
            {
            case CRYS_HASH_SHA1_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data,
                                           CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA224_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA224_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA224_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA224_Expected_output_data,
                                           CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA256_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA256_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA256_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA256_Expected_output_data,
                                           CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA384_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA384_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA384_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA384_Expected_output_data,
                                           CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_SHA512_mode:
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA512_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_SHA512_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_SHA512_Expected_output_data,
                                           CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES);
                break;
            case CRYS_HASH_MD5_mode:                                       
               TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_MD5_Expected_output_data ,
                                                          TST_HASH_Acceptance_TestData[TST_index].TST_MD5_Expected_dataSize);            

                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                           "\nData Expected by engine [expected buffer]--\n",
                                           TST_HASH_Acceptance_TestData[TST_index].TST_MD5_Expected_output_data,
                                           CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES);
                break;
                default:
                    break;
            }
                
            ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                        "\nData outputted by engine [output buffer]--\n",
                                        (DxUint8_t *)TST_HASH_Acceptance_TestData[TST_index].TST_HashResultBuff,
                                        CRYS_HASH_RESULT_SIZE_IN_WORDS*sizeof(DxUint32_t));                   

            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_HASH_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
              
        }/*End of TST_index//TST_NumberOfAcceptanceTests*/      
    } /* End of TST_HashType loop*/
  return TST_Status;
   
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
} /*End of test*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
#endif

